import random
import colorsys
import math

def clamp(v, a, b):
    return max(a, min(v, b))

def srgb_to_linear(v):
    v = v / 255.0
    return ((v + 0.055) / 1.055) ** 2.4 if v > 0.04045 else v / 12.92

def rgb_to_oklch(r, g, b):
    # Convert sRGB 0-255 to linear RGB
    R = srgb_to_linear(r)
    G = srgb_to_linear(g)
    B = srgb_to_linear(b)

    # Linear RGB to LMS
    l = 0.4122214708 * R + 0.5363325363 * G + 0.0514459929 * B
    m = 0.2119034982 * R + 0.6806995451 * G + 0.1073969566 * B
    s = 0.0883024619 * R + 0.2817188376 * G + 0.6299787005 * B

    # Non-linear
    l_, m_, s_ = l ** (1/3), m ** (1/3), s ** (1/3)

    L = 0.2104542553 * l_ + 0.7936177850 * m_ - 0.0040720468 * s_
    a = 1.9779984951 * l_ - 2.4285922050 * m_ + 0.4505937099 * s_
    b = 0.0259040371 * l_ + 0.7827717662 * m_ - 0.8086757660 * s_

    C = math.sqrt(a * a + b * b)
    h = math.degrees(math.atan2(b, a)) % 360
    return round(L, 3), round(C, 3), round(h, 1)

def rgb_to_hex(r, g, b):
    return '#{:02X}{:02X}{:02X}'.format(r, g, b)

def rgb_to_hsl_str(r, g, b):
    h, l, s = colorsys.rgb_to_hls(r/255.0, g/255.0, b/255.0)
    return f"{int(h*360)}, {int(s*100)}%, {int(l*100)}%"

def generate_random_color():
    r = random.randint(0,255)
    g = random.randint(0,255)
    b = random.randint(0,255)
    hexc = rgb_to_hex(r,g,b)
    rgb = f"{r}, {g}, {b}"
    hsl = rgb_to_hsl_str(r,g,b)
    L, C, H = rgb_to_oklch(r,g,b)
    oklch = f"{L}, {C}, {H}"
    return {'hex': hexc, 'rgb': rgb, 'hsl': hsl, 'oklch': oklch}

def generate_random_palette(n=5):
    return [generate_random_color() for _ in range(n)]
